/*
 * Decompiled with CFR 0.152.
 */
package rns2tf3;

import java.util.ArrayList;
import java.util.HashMap;

public class PatternTrack {
    int m_patternIndex;
    int m_trackNr;
    int m_numberOfLines;
    int m_numID;
    ArrayList<String> trackXmlFragments = new ArrayList();
    static int m_trackIdCounter = 0;
    static HashMap<String, Integer> m_noteTranslator = new HashMap();
    static HashMap<String, Integer> m_instTranslator = new HashMap();

    PatternTrack(int patternIndex, int trackNr, int numberOfLines) {
        this.m_patternIndex = patternIndex;
        this.m_trackNr = trackNr;
        this.m_numberOfLines = numberOfLines;
        this.m_numID = m_trackIdCounter++;
    }

    void setNote(int trackNr, String line, String instrument, String noteVal) {
        String fragment;
        while (this.trackXmlFragments.size() <= trackNr) {
            fragment = "       <track>\n";
            this.trackXmlFragments.add(fragment);
        }
        fragment = this.trackXmlFragments.get(trackNr);
        System.out.println("Pattern " + this.m_patternIndex + ":" + this.m_trackNr + " Line " + line + ": " + noteVal + " - " + instrument);
        int note = m_noteTranslator.get(noteVal);
        int inst = m_instTranslator.get(instrument);
        fragment = fragment + "               <ne i=\"" + inst + "\" n=\"" + note + "\" r=\"" + line + "\" v=\"-1\" e=\"0\"/>\n";
        this.trackXmlFragments.set(trackNr, fragment);
    }

    boolean isIdentical(PatternTrack other) {
        if (this.trackXmlFragments.size() != other.trackXmlFragments.size()) {
            return false;
        }
        for (int i = 0; i < this.trackXmlFragments.size(); ++i) {
            if (this.trackXmlFragments.get(i).equals(other.trackXmlFragments.get(i))) continue;
            return false;
        }
        return true;
    }

    String getXml() {
        String Result2 = "<pattern rowcount=\"" + this.m_numberOfLines + "\" patternid=\"" + this.m_numID + "\" trackcount=\"" + this.trackXmlFragments.size() + "\">\n" + "   <tracks>\n";
        for (String fragment : this.trackXmlFragments) {
            Result2 = Result2 + fragment;
            Result2 = Result2 + "       </track>\n";
        }
        Result2 = Result2 + "   </tracks>\n</pattern>";
        return Result2;
    }

    static void init() {
        int base;
        m_noteTranslator.put("OFF", 128);
        for (int oct = 0; oct < 9; ++oct) {
            base = oct * 12 + 1;
            m_noteTranslator.put("C-" + oct, base + 0);
            m_noteTranslator.put("C#" + oct, base + 1);
            m_noteTranslator.put("D-" + oct, base + 2);
            m_noteTranslator.put("D#" + oct, base + 3);
            m_noteTranslator.put("E-" + oct, base + 4);
            m_noteTranslator.put("F-" + oct, base + 5);
            m_noteTranslator.put("F#" + oct, base + 6);
            m_noteTranslator.put("G-" + oct, base + 7);
            m_noteTranslator.put("G#" + oct, base + 8);
            m_noteTranslator.put("A-" + oct, base + 9);
            m_noteTranslator.put("A#" + oct, base + 10);
            m_noteTranslator.put("B-" + oct, base + 11);
        }
        m_instTranslator.put("..", -1);
        for (int i = 0; i < 10; ++i) {
            base = i * 16;
            for (int k = 0; k < 10; ++k) {
                m_instTranslator.put("" + i + "" + k, base + k);
            }
            m_instTranslator.put("" + i + "A", base + 10);
            m_instTranslator.put("" + i + "B", base + 11);
            m_instTranslator.put("" + i + "C", base + 12);
            m_instTranslator.put("" + i + "D", base + 13);
            m_instTranslator.put("" + i + "E", base + 14);
            m_instTranslator.put("" + i + "F", base + 15);
        }
    }
}

