/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *   This file is part of
 *       _______   ______________  ______     _____
 *      / ____/ | / /  _/ ____/  |/  /   |   |__  /
 *     / __/ /  |/ // // / __/ /|_/ / /| |    /_ <
 *    / /___/ /|  // // /_/ / /  / / ___ |  ___/ /
 *   /_____/_/ |_/___/\____/_/  /_/_/  |_| /____/.
 *
 *   Copyright  2003-2010 Brain Control, all rights reserved.
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef BUFFERS_DX11_HPP
#define BUFFERS_DX11_HPP

class eIndexBufferDx11 : public eResourceDx11
{
private:
    eIndexBufferDx11();
    eIndexBufferDx11(const eIndexBufferDx11 &ib);
    eIndexBufferDx11 & operator = (eIndexBufferDx11 &ib);

public:
    eIndexBufferDx11(ID3D11Device *dev, ID3D11DeviceContext *devContext, eU32 count, eBool dynamic);
    virtual ~eIndexBufferDx11();

    eBool                           upload();
    eBool                           unload();

    eU32                            getCount() const;

private:
    eU32                            m_count;
};

class eVertexBufferDx11 : public eResourceDx11
{
private:
    eVertexBufferDx11();
    eVertexBufferDx11(const eVertexBufferDx11 &vb);
    eVertexBufferDx11 & operator = (eVertexBufferDx11 &vb);

public:
    eVertexBufferDx11(ID3D11Device *dev, ID3D11DeviceContext *devContext, eU32 count, eU32 vertexSize, eBool dynamic);
    virtual ~eVertexBufferDx11();

    eBool                           upload();
    eBool                           unload();

    eU32                            getByteSize() const;
    eU32                            getVertexSize() const;

private:
    eU32                            m_vertexSize;
	eU32							m_count;
};

class eConstantBufferDx11 : public eResourceDx11
{
private:
    eConstantBufferDx11();
    eConstantBufferDx11(const eConstantBufferDx11 &vb);
    eConstantBufferDx11 & operator = (eConstantBufferDx11 &vb);

public:
    eConstantBufferDx11(ID3D11Device *dev, ID3D11DeviceContext *devContext);
    virtual ~eConstantBufferDx11();

    eBool                           upload();
    eBool                           unload();

    void                            update();

    void                            set(eU32 offset, eF32 f);
    void                            set(eU32 offset, const eMatrix4x4 &m);
    void                            set(eU32 offset, const eColor &v);
    void                            set(eU32 offset, const eVector4 &v);
    void                            set(eU32 offset, const eVector3 &v);
    void                            set(eU32 offset, const eVector2 &v);

private:
    eVector4                        m_constants[eSHADER_CONSTANT_COUNT];
    eBool                           m_changed;
};

#endif // BUFFERS_DX11_HPP