/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *   This file is part of
 *       _______   ______________  ______     _____
 *      / ____/ | / /  _/ ____/  |/  /   |   |__  /
 *     / __/ /  |/ // // / __/ /|_/ / /| |    /_ <
 *    / /___/ /|  // // /_/ / /  / / ___ |  ___/ /
 *   /_____/_/ |_/___/\____/_/  /_/_/  |_| /____/.
 *
 *   Copyright  2003-2010 Brain Control, all rights reserved.
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <d3d11.h>
#include <d3dx11.h>

#include "../../eshared.hpp"

static const eU32 INPUT_LAYOUT_ELEMENTS[eVTXTYPE_COUNT-1] = { 12, 3 };

static const D3D11_INPUT_ELEMENT_DESC INPUT_LAYOUTS[eVTXTYPE_COUNT-1][13] =
{
    // Default vertex declaration.
    {
        { "POSITION", 0, DXGI_FORMAT_R32G32B32_FLOAT, 0,  0, D3D11_INPUT_PER_VERTEX_DATA, 0 },
        { "NORMAL",   0, DXGI_FORMAT_R32G32B32_FLOAT, 0, 12, D3D11_INPUT_PER_VERTEX_DATA, 0 },
        { "TEXCOORD", 0, DXGI_FORMAT_R32G32_FLOAT,    0, 24, D3D11_INPUT_PER_VERTEX_DATA, 0 },
        { "COLOR",    0, DXGI_FORMAT_R8G8B8A8_UNORM,  0, 32, D3D11_INPUT_PER_VERTEX_DATA, 0 },

        { "TEXCOORD", 1, DXGI_FORMAT_R32G32B32A32_FLOAT, 1,   0, D3D11_INPUT_PER_INSTANCE_DATA, 1 },
        { "TEXCOORD", 2, DXGI_FORMAT_R32G32B32A32_FLOAT, 1,  16, D3D11_INPUT_PER_INSTANCE_DATA, 1 },
        { "TEXCOORD", 3, DXGI_FORMAT_R32G32B32A32_FLOAT, 1,  32, D3D11_INPUT_PER_INSTANCE_DATA, 1 },
        { "TEXCOORD", 4, DXGI_FORMAT_R32G32B32A32_FLOAT, 1,  48, D3D11_INPUT_PER_INSTANCE_DATA, 1 },
        { "TEXCOORD", 5, DXGI_FORMAT_R32G32B32A32_FLOAT, 1,  64, D3D11_INPUT_PER_INSTANCE_DATA, 1 },
        { "TEXCOORD", 6, DXGI_FORMAT_R32G32B32A32_FLOAT, 1,  80, D3D11_INPUT_PER_INSTANCE_DATA, 1 },
        { "TEXCOORD", 7, DXGI_FORMAT_R32G32B32A32_FLOAT, 1,  96, D3D11_INPUT_PER_INSTANCE_DATA, 1 },
        { "TEXCOORD", 8, DXGI_FORMAT_R32G32B32A32_FLOAT, 1, 112, D3D11_INPUT_PER_INSTANCE_DATA, 1 }
    },

    // Vertex declaration for particles.
    {
        { "POSITION", 0, DXGI_FORMAT_R32G32B32_FLOAT, 0,  0, D3D11_INPUT_PER_VERTEX_DATA, 0 },
        { "TEXCOORD", 0, DXGI_FORMAT_R32G32_FLOAT,    0, 12, D3D11_INPUT_PER_VERTEX_DATA, 0 },
        { "COLOR",    0, DXGI_FORMAT_R8G8B8A8_UINT,   0, 20, D3D11_INPUT_PER_VERTEX_DATA, 0 },

        { "TEXCOORD", 1, DXGI_FORMAT_R32G32B32A32_FLOAT, 1,   0, D3D11_INPUT_PER_INSTANCE_DATA, 1 },
        { "TEXCOORD", 2, DXGI_FORMAT_R32G32B32A32_FLOAT, 1,  16, D3D11_INPUT_PER_INSTANCE_DATA, 1 },
        { "TEXCOORD", 3, DXGI_FORMAT_R32G32B32A32_FLOAT, 1,  32, D3D11_INPUT_PER_INSTANCE_DATA, 1 },
        { "TEXCOORD", 4, DXGI_FORMAT_R32G32B32A32_FLOAT, 1,  48, D3D11_INPUT_PER_INSTANCE_DATA, 1 },
        { "TEXCOORD", 5, DXGI_FORMAT_R32G32B32A32_FLOAT, 1,  64, D3D11_INPUT_PER_INSTANCE_DATA, 1 },
        { "TEXCOORD", 6, DXGI_FORMAT_R32G32B32A32_FLOAT, 1,  80, D3D11_INPUT_PER_INSTANCE_DATA, 1 },
        { "TEXCOORD", 7, DXGI_FORMAT_R32G32B32A32_FLOAT, 1,  96, D3D11_INPUT_PER_INSTANCE_DATA, 1 },
        { "TEXCOORD", 8, DXGI_FORMAT_R32G32B32A32_FLOAT, 1, 112, D3D11_INPUT_PER_INSTANCE_DATA, 1 }
    }
};

eInputLayoutDx11::eInputLayoutDx11(ID3D11Device *dev, eVertexType type, eShader *shader) :
    m_inputLayout(eNULL)
{
    HRESULT result = dev->CreateInputLayout(INPUT_LAYOUTS[type], INPUT_LAYOUT_ELEMENTS[type], shader->getByteCode(), shader->getByteCodeLen(), &m_inputLayout);
    eASSERT(!FAILED(result));
}

eInputLayoutDx11::~eInputLayoutDx11()
{
    eSAFE_RELEASE_COM(m_inputLayout);
}

ID3D11InputLayout * eInputLayoutDx11::getInputLayout()
{
    return m_inputLayout;
}
