/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *   This file is part of
 *       _______   ______________  ______     _____
 *      / ____/ | / /  _/ ____/  |/  /   |   |__  /
 *     / __/ /  |/ // // / __/ /|_/ / /| |    /_ <
 *    / /___/ /|  // // /_/ / /  / / ___ |  ___/ /
 *   /_____/_/ |_/___/\____/_/  /_/_/  |_| /____/.
 *
 *   Copyright  2003-2010 Brain Control, all rights reserved.
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef RESOURCE_DX11_HPP
#define RESOURCE_DX11_HPP

class eResourceDx11 
{
protected:
    eResourceDx11();

public:
    eResourceDx11(ID3D11Device *dev, ID3D11DeviceContext *devContext, eBool dynamic);
    virtual ~eResourceDx11();

    ePtr                                    lock();
    ePtr                                    lock(eBufferLock locktype);
    void                                    unlock();
    eBool                                   isDynamic() const;

	void                                    createShaderResourceView();
	void									createRenderTargetView();
	void									createRenderTargetViewsCube();
	void									createDepthStencilView();
    ID3D11ShaderResourceView *              getShaderResourceView();
	ID3D11RenderTargetView *				getRenderTargetView();
	ID3D11RenderTargetView *				getRenderTargetViewCube(eCubeMapFace face);
	ID3D11DepthStencilView *				getDepthStencilView();

	ID3D11Resource *						getResource();
	void                                    releaseResource();

protected:
    ID3D11Resource *                        m_resource;
    ID3D11ShaderResourceView *              m_shaderResourceView;
	ID3D11RenderTargetView *				m_renderTargetView;
	ID3D11RenderTargetView *				m_renderTargetViewsCube[6];
	ID3D11DepthStencilView *				m_depthStencilView;

    ID3D11Device *                          m_device;
    ID3D11DeviceContext *                   m_deviceContext;
    
    eBool                                   m_dynamic;
    eBool                                   m_locked;
};

#endif
