/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *   This file is part of
 *       _______   ______________  ______     _____
 *      / ____/ | / /  _/ ____/  |/  /   |   |__  /
 *     / __/ /  |/ // // / __/ /|_/ / /| |    /_ <
 *    / /___/ /|  // // /_/ / /  / / ___ |  ___/ /
 *   /_____/_/ |_/___/\____/_/  /_/_/  |_| /____/.
 *
 *   Copyright  2003-2010 Brain Control, all rights reserved.
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef SHADERS_DX11_HPP
#define SHADERS_DX11_HPP

class eShaderDx11 
{
protected:
    eShaderDx11();

public:
    eShaderDx11(ID3D11Device *dev, ID3D11DeviceContext *devContext);
    virtual ~eShaderDx11();

    virtual eBool               load(eShaderSource src) = 0;
    virtual void                bind() = 0;

    eBool                       compile(eShaderSource src, eChar *model);
    const eU8 *                 getByteCode();
    eU32                        getByteCodeLen();

protected:
    ID3D11DeviceChild *         m_shader;
    ID3D11Device *              m_device;
    ID3D11DeviceContext *       m_deviceContext;

    eU8 *                       m_byteCode;
    eU32                        m_byteCodeLen;
};

class ePixelShaderDx11 : public eShaderDx11
{
private:
    ePixelShaderDx11();
    ePixelShaderDx11(const ePixelShaderDx11 &ps);
    ePixelShaderDx11 & operator = (const ePixelShaderDx11 &ps);

public:
    ePixelShaderDx11(ID3D11Device *dev, ID3D11DeviceContext *devContext, eShaderSource src);

    virtual eBool               load(eShaderSource src);
    virtual void                bind();
};

class eVertexShaderDx11 : public eShaderDx11
{
private:
    eVertexShaderDx11();
    eVertexShaderDx11(const eVertexShaderDx11 &ps);
    eVertexShaderDx11 & operator = (const eVertexShaderDx11 &ps);

public:
    eVertexShaderDx11(ID3D11Device *dev, ID3D11DeviceContext *devContext, eShaderSource src);

    virtual eBool               load(eShaderSource src);
    virtual void                bind();
};

class eGeometryShaderDx11 : public eShaderDx11
{
private:
	eGeometryShaderDx11();
	eGeometryShaderDx11(const eGeometryShaderDx11 &ps);
	eGeometryShaderDx11 & operator = (const eGeometryShaderDx11 &ps);

public:
	eGeometryShaderDx11(ID3D11Device *dev, ID3D11DeviceContext *devContext, eShaderSource src);

	virtual eBool               load(eShaderSource src);
	virtual void                bind();
};

class eHullShaderDx11 : public eShaderDx11
{
private:
	eHullShaderDx11();
	eHullShaderDx11(const eHullShaderDx11 &ps);
	eHullShaderDx11 & operator = (const eHullShaderDx11 &ps);

public:
	eHullShaderDx11(ID3D11Device *dev, ID3D11DeviceContext *devContext, eShaderSource src);

	virtual eBool               load(eShaderSource src);
	virtual void                bind();
};

class eDomainShaderDx11 : public eShaderDx11
{
private:
	eDomainShaderDx11();
	eDomainShaderDx11(const eDomainShaderDx11 &ps);
	eDomainShaderDx11 & operator = (const eDomainShaderDx11 &ps);

public:
	eDomainShaderDx11(ID3D11Device *dev, ID3D11DeviceContext *devContext, eShaderSource src);

	virtual eBool               load(eShaderSource src);
	virtual void                bind();
};

class eComputeShaderDx11 : public eShaderDx11
{
private:
	eComputeShaderDx11();
	eComputeShaderDx11(const eComputeShaderDx11 &ps);
	eComputeShaderDx11 & operator = (const eComputeShaderDx11 &ps);

public:
	eComputeShaderDx11(ID3D11Device *dev, ID3D11DeviceContext *devContext, eShaderSource src);

	virtual eBool               load(eShaderSource src);
	virtual void                bind();
};

#endif // SHADERS_DX11_HPP