/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *   This file is part of
 *       _______   ______________  ______     _____
 *      / ____/ | / /  _/ ____/  |/  /   |   |__  /
 *     / __/ /  |/ // // / __/ /|_/ / /| |    /_ <
 *    / /___/ /|  // // /_/ / /  / / ___ |  ___/ /
 *   /_____/_/ |_/___/\____/_/  /_/_/  |_| /____/.
 *
 *   Copyright  2003-2010 Brain Control, all rights reserved.
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef STATE_DX11_HPP
#define STATE_DX11_HPP

class eStateDx11
{
public:
    virtual void                activate(eU32 index, ID3D11Device *device, ID3D11DeviceContext *deviceContext) = 0; 
    virtual eU32                getHash() const = 0;

protected:
    eU32                        _hash(eU32 hash, eU32 value) const;

    static eBinTree             m_states;
};

class eBlendStateDx11 : public eStateDx11
{
public:
    eBlendStateDx11();

    virtual void                activate(eU32 index, ID3D11Device *device, ID3D11DeviceContext *deviceContext);
    virtual eU32                getHash() const;

    eBool                       blendingOn;
    eBlendMode                  blendSrc;
    eBlendMode                  blendDst;
    eBlendOp                    blendOp;
    eBool                       colorWriteOn;
};

class eSamplerStateDx11 : public eStateDx11
{
public:
    eSamplerStateDx11();

    virtual void                activate(eU32 index, ID3D11Device *device, ID3D11DeviceContext *deviceContext);
    virtual eU32                getHash() const;

    eTextureFilter              texFilter;
    eTextureAddressMode         texAddrMode;
};

class eRasterizerStateDx11 : public eStateDx11
{
public:
    eRasterizerStateDx11();

    virtual void                activate(eU32 index, ID3D11Device *device, ID3D11DeviceContext *deviceContext);
    virtual eU32                getHash() const;

    eBool                       alphaTestOn;
    eBool                       scissorTestOn;
    eCullingMode                cullingMode;
};

class eDepthStencilStateDx11 : public eStateDx11
{
public:
    eDepthStencilStateDx11();

    virtual void                activate(eU32 index, ID3D11Device *device, ID3D11DeviceContext *deviceContext);
    virtual eU32                getHash() const;

    eBool                       depthTestOn;
    eBool                       zWriteOn;
    eZFunction                  zFunc;
};

#endif
