/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *   This file is part of
 *       _______   ______________  ______     _____
 *      / ____/ | / /  _/ ____/  |/  /   |   |__  /
 *     / __/ /  |/ // // / __/ /|_/ / /| |    /_ <
 *    / /___/ /|  // // /_/ / /  / / ___ |  ___/ /
 *   /_____/_/ |_/___/\____/_/  /_/_/  |_| /____/.
 *
 *   Copyright  2003-2010 Brain Control, all rights reserved.
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef TEXTURES_DX11_HPP
#define TEXTURES_DX11_HPP

class eTextureDx11 : public eResourceDx11
{
protected:
    eTextureDx11();

public:
    eTextureDx11(ID3D11Device *dev, ID3D11DeviceContext *devContext, eBool dynamic, eU32 width, eU32 height, eU32 depth, eBool renderTarget, eBool mipMapped, eFormat format);
    virtual ~eTextureDx11();

    void                        release();
    eSize						getSize() const;
    eU32						getWidth() const;
    eU32						getHeight() const;
    eU32						getDepth() const;
    eFormat						getFormat() const;
    eBool						isMipMapped() const;
    eBool						isRenderTarget() const;
	eBool						isCube() const;

protected:
    DXGI_FORMAT                 m_dxgiFormat;
    eU32                        m_width;
    eU32                        m_height;
    eU32                        m_depth;
    eU32                        m_pixelSize;
    eBool                       m_mipMapped;
    eFormat                     m_format;
    eBool                       m_renderTarget;
    ePtr                        m_data;
	eBool						m_isCube;
};

class eTexture2dDx11 : public eTextureDx11
{
private:
    eTexture2dDx11();
    eTexture2dDx11(const eTexture2dDx11 &tex);
    eTexture2dDx11 & operator = (eTexture2dDx11 &tex);

public:
    eTexture2dDx11(ID3D11Device *dev, ID3D11DeviceContext *devContext, eU32 width, eU32 height, const ePtr data, eBool renderTarget, eBool mipMapped, eBool dynamic, eFormat format);
    virtual ~eTexture2dDx11();

    virtual eBool               upload();

#ifndef eINTRO
    virtual void                saveToFile(const eChar *fileName);
#endif
};

class eTexture3dDx11 : public eTextureDx11
{
private:
    eTexture3dDx11();
    eTexture3dDx11(const eTexture3dDx11 &tex);
    eTexture3dDx11 & operator = (eTexture3dDx11 &tex);

public:
    eTexture3dDx11(ID3D11Device *dev, ID3D11DeviceContext *devContext, eU32 width, eU32 height, eU32 depth, eBool mipMapped, eBool dynamic, eFormat format);
    virtual ~eTexture3dDx11();

    virtual eBool               upload();
};

class eTextureCubeDx11 : public eTextureDx11
{
private:
    eTextureCubeDx11();
    eTextureCubeDx11(const eTextureCubeDx11 &tex);
    eTextureCubeDx11 & operator = (eTextureCubeDx11 &tex);

public:
    eTextureCubeDx11(ID3D11Device *dev, ID3D11DeviceContext *devContext, eU32 width, eBool renderTarget, eBool mipMapped, eBool dynamic, eFormat format);
    virtual ~eTextureCubeDx11();

    virtual eBool               upload();

#ifndef eINTRO
    virtual void                saveToFile(const eChar *fileName);
#endif
};

#endif // TEXTURES_DX11_HPP