/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *   This file is part of
 *       _______   ______________  ______     _____
 *      / ____/ | / /  _/ ____/  |/  /   |   |__  /
 *     / __/ /  |/ // // / __/ /|_/ / /| |    /_ <
 *    / /___/ /|  // // /_/ / /  / / ___ |  ___/ /
 *   /_____/_/ |_/___/\____/_/  /_/_/  |_| /____/.
 *
 *   Copyright  2003-2010 Brain Control, all rights reserved.
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef LSYS2_CONTEXT_HPP
#define LSYS2_CONTEXT_HPP

#include "../../eshared.hpp"

#define ELSYS2_SYMBOL_COUNT 256

enum ELSYS_CONTEXT_PARAMETER {
	CTX_ROTATION_UNIT_X,
	CTX_ROTATION_UNIT_Y,
	CTX_ROTATION_UNIT_Z,
	CTX_DECAY,
	CTX__LENGTH,
	CTX_GRAVITY,
};

class eLsys2_Symbol;
class eLsys2_SymbolInstance;
class eLsys2_Evaluator;

class eLSys2_Context {
public:
	eLSys2_Context(); 

	eLsys2_SymbolInstance&	getInstance(eU32 idx) {
		return m_symbolInstances[idx];
	}

	eU32	addInstance(eLsys2_Evaluator* state, eU32 symbolIndex, eU32 parent);

	eF32&	param(ELSYS_CONTEXT_PARAMETER par) {
		return this->m_parameters[par];
	}

    void setSymbol(eU32 s, eLsys2_Symbol* symbol) {
        this->m_symbolTable[s] = symbol;
    }
    eLsys2_Symbol* getSymbol(eU32 s) {
        return this->m_symbolTable[s];
    }

    void merge(eLSys2_Context& ctx) {
        for(eU32 i = 0; i < ELSYS2_SYMBOL_COUNT; i++) {
            eLsys2_Symbol* sym = ctx.getSymbol(i);
            if(sym) {
                this->setSymbol(i, sym);
            }
        }
    }

    void evaluateSingleInstance(eF32 time, eLsys2_Evaluator* evaluator);

private:
	eArray<eLsys2_SymbolInstance>	m_symbolInstances;
	eF32							m_parameters[CTX__LENGTH];
    eLsys2_Symbol*                  m_symbolTable[ELSYS2_SYMBOL_COUNT];
};

#endif // LSYS2_CONTEXT_HPP
