/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *   This file is part of
 *       _______   ______________  ______     _____
 *      / ____/ | / /  _/ ____/  |/  /   |   |__  /
 *     / __/ /  |/ // // / __/ /|_/ / /| |    /_ <
 *    / /___/ /|  // // /_/ / /  / / ___ |  ___/ /
 *   /_____/_/ |_/___/\____/_/  /_/_/  |_| /____/.
 *
 *   Copyright  2003-2010 Brain Control, all rights reserved.
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef LSYS2_EVALUATOR_HPP
#define LSYS2_EVALUATOR_HPP

#include "../../eshared.hpp"

class eLsys2_Evaluator {
public:
    virtual eU32 initInstance(eLSys2_Context& context, eU32 symbolIndex) = 0;
    virtual void prepare(eLSys2_Context& context, eU32 symbolIndex, eU32 instanceHandle, eF32 blendWeight, eF32 energy, const eF32* parameters) = 0;
    virtual void execute(eLSys2_Context& context, eU32 symbolIndex, eU32 instanceHandle, eF32 blendWeight, eF32 energy, const eF32* parameters) = 0;
private:
};

#endif // LSYS2_EVALUATOR_HPP
