/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *   This file is part of
 *       _______   ______________  ______     _____
 *      / ____/ | / /  _/ ____/  |/  /   |   |__  /
 *     / __/ /  |/ // // / __/ /|_/ / /| |    /_ <
 *    / /___/ /|  // // /_/ / /  / / ___ |  ___/ /
 *   /_____/_/ |_/___/\____/_/  /_/_/  |_| /____/.
 *
 *   Copyright  2003-2010 Brain Control, all rights reserved.
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef LSYS2_HERMITECURVE_HPP
#define LSYS2_HERMITECURVE_HPP

#include "../../eshared.hpp"

class HermiteCurve {
public:
    static void calculate(eF32 t,
                          const eVector3& control0, const eVector3& tangent0, 
                          const eVector3& control1, const eVector3& tangent1,
                          eVector3& resultPos, eVector3& resultTangent) {
        eF32 tt = t * t;
        eF32 ttt = tt * t;

        resultPos = control0 * (2.0f * ttt - 3.0f * tt + 1.0f) + 
                    control1 * (-2.0f * ttt + 3.0f * tt) + 
                    tangent0 * (ttt - 2.0f * tt + t) + 
                    tangent1 * (ttt - tt);

        resultTangent = (6.0f * tt - 6.0f * t)  * control0 +
                       (-6.0f * tt + 6.0f * t) * control1 +
                       (3.0f * tt - 4.0f * t + 1.0f) * tangent0,
                       (3.0f * tt - 2.0f * t) * tangent1;
        resultTangent.normalize();
    }
};


#endif // LSYS2_HERMITECURVE_HPP
