/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *   This file is part of
 *       _______   ______________  ______     _____
 *      / ____/ | / /  _/ ____/  |/  /   |   |__  /
 *     / __/ /  |/ // // / __/ /|_/ / /| |    /_ <
 *    / /___/ /|  // // /_/ / /  / / ___ |  ___/ /
 *   /_____/_/ |_/___/\____/_/  /_/_/  |_| /____/.
 *
 *   Copyright  2003-2010 Brain Control, all rights reserved.
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifdef eEDITOR
#include <windows.h>
#include <stdio.h>
#endif

#include "lsys2.hpp"

void dummy() {
//	eLsys2_SymbolInstance lsym;
}

eLSys2_Context::eLSys2_Context() {
    for(eU32 i = 0; i < ELSYS2_SYMBOL_COUNT; i++)
        this->m_symbolTable[i] = eNULL;
}

eU32	
eLSys2_Context::addInstance(eLsys2_Evaluator* state, eU32 symbolIndex, eU32 parent) {
    eLsys2_SymbolInstance instance(symbolIndex, state, this->getSymbol(symbolIndex), this->m_symbolInstances.size(), parent);
	this->m_symbolInstances.append(instance);
	return m_symbolInstances.size() - 1;
}

void 
eLSys2_Context::evaluateSingleInstance(eF32 time, eLsys2_Evaluator* evaluator) {
    getInstance(0).prepare(0, time,evaluator,*this);
    getInstance(0).evaluate(time,evaluator,*this);
}


void eLsys2_Rule::apply(eLsys2_Evaluator* state, eU32 parentIdx, eLSys2_Context& context) const {
    eU32 derStart = -1;
    eU32 derLen = 0;
    eU32 pos = 0;
    while(m_production[pos] != 0) {
        eU32 symbolNr = m_production[pos];
        eU32 idx = context.addInstance(state, symbolNr, parentIdx);
        if(derStart == -1)
            derStart = idx;
        derLen++;
        pos++;
    }
    context.getInstance(parentIdx).setDerivation(derStart, derLen);
}
