/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *   This file is part of
 *       _______   ______________  ______     _____
 *      / ____/ | / /  _/ ____/  |/  /   |   |__  /
 *     / __/ /  |/ // // / __/ /|_/ / /| |    /_ <
 *    / /___/ /|  // // /_/ / /  / / ___ |  ___/ /
 *   /_____/_/ |_/___/\____/_/  /_/_/  |_| /____/.
 *
 *   Copyright  2003-2010 Brain Control, all rights reserved.
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef LSYS2_RULE_HPP
#define LSYS2_RULE_HPP

#include "../../eshared.hpp"

class eLsys2_Rule {
public:
    eLsys2_Rule() {};
    
    void set(const eChar* axiom, const eChar* condition, const eChar* production) {
        m_axiom = axiom;
        m_condition = condition;
        m_production = production;
    }

	eF32 probability(eLSys2_Context& context) const {
        return 1.0f;
    }
	void apply(eLsys2_Evaluator* state, eU32 parentIdx, eLSys2_Context& context) const;

private:
    const eChar* m_axiom;
    const eChar* m_condition;
    const eChar* m_production;
};

#endif // LSYS2_RULE_HPP
