/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *   This file is part of
 *       _______   ______________  ______     _____
 *      / ____/ | / /  _/ ____/  |/  /   |   |__  /
 *     / __/ /  |/ // // / __/ /|_/ / /| |    /_ <
 *    / /___/ /|  // // /_/ / /  / / ___ |  ___/ /
 *   /_____/_/ |_/___/\____/_/  /_/_/  |_| /____/.
 *
 *   Copyright  2003-2010 Brain Control, all rights reserved.
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef LSYS2_TURTLE_HPP
#define LSYS2_TURTLE_HPP

#include "../../eshared.hpp"

class eLsys2_Turtle {
public:

    void reset(const eVector3& position, const eQuat& rotation, eF32 scale) {
        m_position = position;
        m_rotation = rotation;
        m_scale = scale;
    };

	void move(eF32 units) {
		const eVector3 direction = m_rotation.getVector(2);
		m_position += direction * (m_scale * units);
	}

	void scale(eF32 scale) {
		m_scale *= scale;
	}

	void rotate(eU32 axis, eF32 amount) {
        this->m_rotation = eQuat(this->m_rotation.getVector(axis), amount) * this->m_rotation;
	}

	void lerpTo(eF32 fraction, const eLsys2_Turtle& target) {
		this->m_position = this->m_position.lerp(fraction, target.m_position);
		this->m_rotation = this->m_rotation.slerp(fraction, target.m_rotation);
        this->m_scale = this->m_scale * (1.0f - fraction) + target.m_scale * fraction;
	}

	eVector3					m_position;
	eQuat						m_rotation;
	eF32						m_scale;
};

#endif // TURTLE_HPP
