#ifndef BOX_HPP
#define BOX_HPP

#include "../../../eshared.hpp"
#include "object.hpp"

// Represents a regular box. collision mesh subdivision is taken from
// the config file.
class Box : public Object, public Collision_mesh_object
{
public:
  // box can be solid or just a shell - affects the inertia
  Box(Physics * physics, Scalar side_x, Scalar side_y, Scalar side_z, Scalar mass, bool solid);

  // Rigid_body fns
  Collision_body * collision_body() { return &m_collision_body; }

  void add_external_forces(Scalar dt);

  void get_bounding_sphere(Position & pos, Scalar & radius) {
    m_collision_body.get_bounding_sphere(pos, radius);}

  // used to set up the collision mesh - from Collision_mesh_object
  bool get_mesh_info(const Position & pos, 
                     bool & inside,
                     Vector3 & vector_to_surface) const;

  virtual eU32      getNumPoints() const {
      return 8;
  };
  virtual eVector3  getPoint(eU32 nr) const { 
      eVector3 p;
      switch(nr) {
          case 0: p = eVector3(-0.5f, -0.5f, -0.5f); break;
          case 1: p = eVector3(-0.5f, -0.5f,  0.5f); break;
          case 2: p = eVector3(-0.5f,  0.5f, -0.5f); break;
          case 3: p = eVector3(-0.5f,  0.5f,  0.5f); break;
          case 4: p = eVector3( 0.5f, -0.5f, -0.5f); break;
          case 5: p = eVector3( 0.5f, -0.5f,  0.5f); break;
          case 6: p = eVector3( 0.5f,  0.5f, -0.5f); break;
          case 7: p = eVector3( 0.5f,  0.5f,  0.5f); break;
      }
      return p * eVector3(this->m_side_x, this->m_side_y, this->m_side_z);
  };

private:
  void draw_triangles() const;

  Collision_body m_collision_body;

  std::vector<Collision_triangle> m_triangles;

  Scalar m_side_x, m_side_y, m_side_z;
};

#endif
