#include "collision_body.hpp"

//==============================================================
// Collision_body
//==============================================================
Collision_body::Collision_body(Rigid_body * rigid_body)
{
  m_rigid_body = rigid_body;
}

//==============================================================
// initialise
//==============================================================
void Collision_body::initialise(int mesh_nx, int mesh_ny, int mesh_nz, 
                                Scalar mesh_extra_frac, 
                                const std::vector<Collision_triangle> & triangles,
                                const std::vector<Position> & points,
                                const std::vector<Position> & edge_points,
                                const std::vector<Collision_body_edge> & edges,
                                const Collision_mesh_object * mesh_object)
{
  m_body_mesh.construct_mesh(mesh_nx, mesh_ny, mesh_nz, mesh_extra_frac, triangles, mesh_object);

  m_body_points = points;
  m_body_edge_points = edge_points;
  m_edges = edges;

  m_position.set_to(0.0f);
  m_orientation = matrix3_identity();

  calculate_world_properties();
}

//==============================================================
// initialise
//==============================================================
void Collision_body::initialise(int mesh_nx, int mesh_ny, int mesh_nz, 
                                Scalar mesh_extra_frac, 
                                const std::vector<Collision_triangle> & triangles,
                                const std::vector<Position> & points,
                                const std::vector<Position> & edge_points,
                                const std::vector<Collision_body_edge> & edges,
                                const Collision_body_mesh & mesh)
{
  m_body_mesh.construct_mesh(mesh);

  m_body_points = points;
  m_body_edge_points = edge_points;
  m_edges = edges;

  m_position.set_to(0.0f);
  m_orientation = matrix3_identity();

  calculate_world_properties();
}

//==============================================================
// calculate_world_properties
//==============================================================
void Collision_body::calculate_world_properties()
{
  int num = m_body_points.size();
  int i;

  m_world_points.resize(m_body_points.size());
  for (i = 0 ; i < num ; ++i)
  {
    m_world_points[i] = m_position + m_orientation * m_body_points[i];
  }

  m_world_edge_points.resize(m_body_edge_points.size());
  num = m_body_edge_points.size();
  for (i = 0 ; i < num ; ++i)
  {
    m_world_edge_points[i] = m_position + m_orientation * m_body_edge_points[i];
  }
}


//==============================================================
// debug_render_mesh
//==============================================================
void Collision_body::debug_render_mesh()
{
}

//==============================================================
// debug_render_points_and_edges
//==============================================================
void Collision_body::debug_render_points_and_edges()
{
}

//==============================================================
// remove_all_point_info
//==============================================================
void Collision_body::remove_all_point_info()
{
  m_body_edge_points.clear();
  m_body_points.clear();
  m_edges.clear();
  m_world_points.clear();
  m_world_edge_points.clear();
}
