#ifndef COLLISION_PROCESSOR_HPP
#define COLLISION_PROCESSOR_HPP

#include "coll_detect.hpp"

/// An interface class to allow objects to override collision
/// response. Most objects will use the default Physics collision
/// handler, but certain jointed objects may want to pass impulses
/// through their components (e.g. sideways forces on a car tyre may
/// bet passed straight to the car body).
class Collision_processor
{
public:
  virtual ~Collision_processor() {}
  
  /// Set up any parameters that will not change as the collision
  /// gets processed - e.g. the relative position, elasticity etc.
  virtual void preprocess_collision(Collision_info & collision, Scalar dt);
  
  /// Handle an individual collision by classifying it, calculating
  /// impulse, applying impulse and updating the velocities of the
  /// objects. Allows over-riding of the elasticity. et val indicates
  /// if an impulse was applied
  virtual bool process_collision(Collision_info & collision, 
                                 Scalar dt, 
                                 bool override_elasticity,
                                 Scalar epsilon = 0.0f);
};

#endif
