#ifndef CONSTRAINT_HPP
#define CONSTRAINT_HPP

#include "types.hpp"

/// defines the interface for constraints to be applied between Rigid_bodies
class Constraint
{
public:
  Constraint() {};
  virtual ~Constraint() {}

  // prepare for applying constraints - the subsequent calls to apply will all occur with a constant position
  // i.e. precalculate everything possible
  virtual void pre_apply(Scalar dt) {}

  // apply the constraint by adding impulses
  virtual bool apply(Scalar dt) = 0;
};

#endif
