#ifndef CONSTRAINT_BODY_BODY_MAX_DISTANCE_HPP
#define CONSTRAINT_BODY_BODY_MAX_DISTANCE_HPP

#include "constraint.hpp"

class Rigid_body;

/// Constraints a point on one body to be fixed to a point on another body
class Constraint_body_body_max_distance : public Constraint
{
public:
  Constraint_body_body_max_distance(Rigid_body * body0, Position body0_pos,
                                    Rigid_body * body1, Position body1_pos,
                                    Scalar max_distance);

  /// A default constructor - but make sue you call initialise
  /// before using!
  Constraint_body_body_max_distance();
  
  void initialise(Rigid_body * body0, Position body0_pos,
                  Rigid_body * body1, Position body1_pos,
                  Scalar max_distance);
  
  void pre_apply(Scalar dt);

  bool apply(Scalar dt);

private:
  // configuration
  Rigid_body * m_body0;
  Rigid_body * m_body1;
  Position m_body0_pos;
  Position m_body1_pos;
  Scalar m_max_distance;
  // stuff that gets updated
  Position m_r0;
  Position m_r1;
  Position m_world_pos;
  Position m_current_rel_pos0;
};

#endif
