#ifndef CONSTRAINT_FIXED_POINT_HPP
#define CONSTRAINT_FIXED_POINT_HPP

#include "constraint.hpp"
#include "types.hpp"

class Rigid_body;

/// Constrains a point within a rigid body to remain at a fixed world point
class Constraint_fixed_point : public Constraint
{
public:
  Constraint_fixed_point(Rigid_body * body,
                         Position point_on_body,
                         Position world_position);

  bool apply(Scalar dt);
private:
  Rigid_body * m_body;
  Position m_point_on_body;
  Position m_world_position;
};

#endif
