#ifndef CYLINDER_HPP
#define CYLINDER_HPP

#include "object.hpp"

// Represents a Cylinder with the axis along x. collision mesh subdivision is taken from
// the config file.
class Cylinder : public Object, public Collision_mesh_object
{
public:
  Cylinder(Physics * physics, 
           Scalar radius, Scalar length, 
           int slices, int stacks,
           Scalar mass);

  // Rigid_body fns
  Collision_body * collision_body() { return &m_collision_body; }

  void add_external_forces(Scalar dt);


  void get_bounding_sphere(Position & pos, Scalar & radius) {
    m_collision_body.get_bounding_sphere(pos, radius);}

  // used to set up the collision mesh - from Collision_mesh_object
  bool get_mesh_info(const Position & pos, 
                     bool & inside,
                     Vector3 & vector_to_surface) const;

private:
  void draw_triangles() const;

  Collision_body m_collision_body;

  std::vector<Collision_triangle> m_triangles;

  Vector3 m_colour_left, m_colour_right;

  Scalar m_radius, m_length;
};

#endif
