#ifndef DISTANCE_HPP
#define DISTANCE_HPP

#include "types.hpp"

//==============================================================
// The fundamental distance functions (sqr and normal versions)
//==============================================================

struct Triangle
{
  Triangle(const Position & origin, const Vector3 & edge0, const Vector3 & edge1) 
    : origin(origin), edge0(edge0), edge1(edge1) {}
  Position origin;
  Vector3 edge0;
  Vector3 edge1;
};

struct Ellipsoid_shape
{
  Ellipsoid_shape(const Vector3 & extents) : extents(extents) {}
  Vector3 extents;
};

Scalar distance_sqr(const Position & point,
                    const Triangle & triangle,
                    Scalar * SParam,
                    Scalar * TParam);

Scalar distance(const Position & point,
                const Triangle & triangle,
                Scalar * SParam,
                Scalar * TParam);

Scalar distance_sqr(Vector3 rkPoint, 
                    const Ellipsoid_shape & rkEllipsoid,
                    Vector3 & rkClosest);


//==============================================================
// Some helpers that do conversions before calling the above fns
//==============================================================


//==============================================================
// returns the squared distance, and calculates the closest point
// on the triangle
//==============================================================
Scalar distance_sqr_point_triangle(const Position & point,
                                   const Position & tri_pos0,
                                   const Position & tri_pos1,
                                   const Position & tri_pos2,
                                   Position & point_on_triangle,
                                   bool & point_on_triangle_edge);




#endif
