#ifndef ELLIPSOID_HPP
#define ELLIPSOID_HPP

#include "object.hpp"

// Represents a regular Ellipsoid. collision mesh subdivision is taken from the config file
// defaults to 10^3
class Ellipsoid : public Object, public Collision_mesh_object
{
public:
  // generate an ellipsoid based on slices and stacks
  Ellipsoid(Physics * physics, Scalar diameter_x, Scalar diameter_y, Scalar diameter_z,
            int slices, int stacks,
            Scalar mass);

  // generate an ellipsoid based on a warped icosahedron
  Ellipsoid(Physics * physics, Scalar diameter_x, Scalar diameter_y, Scalar diameter_z,
            Scalar mass);

  // Rigid_body fns
  Collision_body * collision_body() { 
    if (m_collision_enabled) 
      return &m_collision_body; 
    else 
      return 0;
  }

  /// inherited from Rigid_body
  void add_external_forces(Scalar dt);

  /// from Render_object
  void get_bounding_sphere(Position & pos, Scalar & radius);

  void enable_collisions(bool enable) {m_collision_enabled = enable;}

  // used to set up the collision mesh - from Collision_mesh_object
  bool get_mesh_info(const Position & pos, 
                     bool & inside,
                     Vector3 & vector_to_surface) const;
private:
  Collision_body m_collision_body;

  std::vector<Collision_triangle> m_triangles;

  // gradient in colour from front to back so we can see rotations
  Vector3 m_colour_front;
  Vector3 m_colour_back;

  Scalar m_radius_x, m_radius_y, m_radius_z;

  bool m_collision_enabled;
};

#endif
