#ifndef JOINT_HPP
#define JOINT_HPP

#include "physics_controller.hpp"

/// virtual base class for all joints
/// All joints are expected to do the following in their constructor:
/// 1. create whatever constraints are necessary
/// 2. register these constraints with the physics engine
class Joint : public Physics_controller
{
public:
  virtual ~Joint() {}

  /// reminder - the derived class needs to implement this!
  virtual void update(Scalar dt) = 0;
};

#endif
