/*
  Copyright (C) 2002 Danny Chapman - flight@rowlhouse.freeserve.co.uk
*/
#ifndef MY_ASSERT_H
#define MY_ASSERT_H

#ifdef NDEBUG
#define assert1(exp)
#define assert2(exp, msg)

#else

#include "log_trace.hpp"

#define DO_SSS_DEATH \
printf(\
"This program has crashed\n" \
"Press 'c <RET>' to continue (bad idea!) or 'q <RET>' to exit SSS.\n"); \
for (;;) {int c = getc(stdin); if (c == 'c') break; else if (c == 'q') abort();}
//if (getc(stdin) != 'c') abort();

#include <stdio.h>
#include <stdlib.h>
#define assert1(exp) \
if (!(exp)) { \
TRACE("Assert %s at %s:%d\n", #exp, __FILE__, __LINE__); \
DO_SSS_DEATH \
}

#define assert2(exp, msg) \
if (!(exp)) { \
TRACE("Assert %s at %s:%d\n%s\n", #exp, __FILE__, __LINE__, msg); \
DO_SSS_DEATH \
}

#endif

#endif // file included
