#ifndef OBJECT_HPP
#define OBJECT_HPP

#include "../../../eshared.hpp"
#include "rigid_body.hpp"

/// represents an object that can be rendered and does physics
class Object : public Rigid_body
{
public:
  Object(Physics * physics) : Rigid_body(physics) {}

  virtual const Position & get_render_position() const {return get_position();}

  virtual const Orientation & get_render_orientation() const {return get_orientation();}

  virtual eU32      getNumPoints() const { return 0;};
  virtual eVector3  getPoint(eU32 nr) const { return eVector3();};
  virtual void      setObjectData(void* data) { m_objData = data;}
  virtual void*     getObjectData() { return m_objData;}

private:
  void*  m_objData;
};

#endif
