#include "object_controller.hpp"
#include "object.hpp"
#include "physics.hpp"

//==============================================================
// Object_controller
//==============================================================
Object_controller::Object_controller(Physics * physics)
:
m_physics(physics),
m_object(0),
m_velocity(0.0f),
m_force_per_vel_per_mass(15.0f),
m_control(false)
{
}

//==============================================================
// set_controller_object
//==============================================================
void Object_controller::set_controller_object(Object * object)
{
  m_object = object;
}

//==============================================================
// set_control_enabled
//==============================================================
void Object_controller::set_control_enabled(bool control)
{
  m_control = control;
}

//==============================================================
// set_controlled_velocity
//==============================================================
void Object_controller::set_controlled_velocity(const Velocity & vel)
{
  m_velocity = vel;
}

//==============================================================
// update
//==============================================================
void Object_controller::update(Scalar dt)
{
  if (m_control && m_object)
  {
    m_physics->activate_object(m_object);
    m_object->add_world_force((m_velocity - m_object->get_velocity() ) * 
                              m_force_per_vel_per_mass * m_object->get_mass());
  }
}
