#ifndef OBJECT_CONTROLLER_HPP
#define OBJECT_CONTROLLER_HPP

#include "physics_controller.hpp"
#include "types.hpp"

class Object;
class Physics;

/// constantly tries to set the velocity of an object
class Object_controller : public Physics_controller
{
public:
  // needs to be told the physics system
  Object_controller(Physics * physics);

  /// pass in 0 if you want to disable controlling any object
  void set_controller_object(Object * object);

  /// make this controller control
  void set_control_enabled(bool control);

  /// set the force to use per m/s difference between current vel and desired vel
  /// when controlling
  void set_force(Scalar force_per_vel_per_mass) {m_force_per_vel_per_mass = force_per_vel_per_mass;}

  /// specifies the velocity that the controlled object should have
  void set_controlled_velocity(const Velocity & vel);

  /// do the control (if enabled)
  void update(Scalar dt);

private:
  Physics * m_physics;
  Object * m_object;
  Velocity m_velocity;
  Scalar m_force_per_vel_per_mass;
  bool m_control;
};

#endif
