#ifndef TETRAHEDRON_HPP
#define TETRAHEDRON_HPP

#include "object.hpp"

// Represents a regular solid tetrahedron. collision mesh subdivision is taken from the config file
class Tetrahedron : public Object
{
public:
  Tetrahedron(Physics * physics, Scalar radius, Scalar mass);

  // Rigid_body fns
  Collision_body * collision_body() { return &m_collision_body; }

  void add_external_forces(Scalar dt);

  
  void get_bounding_sphere(Position & pos, Scalar & radius);

private:
  void draw_triangles() const;

  Collision_body m_collision_body;

  std::vector<Collision_triangle> m_triangles;

};

#endif
