/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *   This file is part of
 *       _______   ______________  ______     _____
 *      / ____/ | / /  _/ ____/  |/  /   |   |__  /
 *     / __/ /  |/ // // / __/ /|_/ / /| |    /_ <
 *    / /___/ /|  // // /_/ / /  / / ___ |  ___/ /
 *   /_____/_/ |_/___/\____/_/  /_/_/  |_| /____/.
 *
 *   Copyright  2003-2010 Brain Control, all rights reserved.
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef BINTREE_HPP
#define BINTREE_HPP

class eBinTree
{
private:
	struct Node
	{
		Node(eU32 k, ePtr d) : key(k), data(d), lower(eNULL), higher(eNULL) { }

		eU32    key;
		ePtr    data;
		Node *  lower;
		Node *  higher;
	};
public:
	eBinTree();
	~eBinTree();

	void        addNode(eU32 key, ePtr data);
	ePtr        findNode(eU32 key);
	eU32		getSize();
private:
	void        _addNode(Node *root, eU32 key, ePtr data);
	ePtr        _findNode(Node *root, eU32 key);
	void        _clear(Node *root);

	Node *      m_root;
	eU32		m_size;
};

#endif
