/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package svgconverter;

import java.util.*;
import java.awt.Color;
import java.util.*;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;

/**
 *
 * @author Pap
 */
public class BezPath {
    Vector<BezSegment>  segments = new Vector<BezSegment>();

    int matchPathNr = -1;
    int matchPathSegNr = -1;
    int matchLen = 0;
    int matchIndex = -1;

    void Lookup(int startPos, Collection<BezPath> oldPathes) {
        int len = 0;

        matchPathNr = -1;
        matchPathSegNr = -1;
        matchLen = 0;

        while((matchLen == len) && (len < this.segments.size() - startPos)) {
            len++;
            // build current lookup list
            LinkedList<BezSegment> curList = new LinkedList<BezSegment>();
            for(int i = 0; i < len; i++)
                curList.add(this.segments.get(startPos + i));

            int pnr = 0;
            int pathBaseIDX = 0;
            // go through all past pathes
            Iterator<BezPath> piter = oldPathes.iterator();
            while(piter.hasNext()) {
                BezPath path = piter.next();
                if(path.segments.size() >= curList.size()) {
                    for(int segStartPos = 0; segStartPos < path.segments.size(); segStartPos++) {
                        boolean matches = true;
                        int i = 0;
                        Iterator<BezSegment> siter = curList.iterator();
                        while(siter.hasNext()) {
                            BezSegment seg = siter.next();
                            BezSegment segTest = path.segments.get((segStartPos - i + path.segments.size()) % path.segments.size());
                            if(!seg.EqualsInverse(segTest)) {
                                matches = false;
                                break;
                            }
                            i++;
                        }
                        if(matches) {
                            matchPathNr = pnr;
                            matchPathSegNr = segStartPos;
                            matchLen = curList.size();
                            matchIndex = pathBaseIDX + segStartPos;
                            break;
                        }
                    }
                }
                if(matchLen == len)
                    break;
                pnr++;
                pathBaseIDX += path.segments.size();
            }
        }
        if(matchLen > 0) {
            System.out.println("Found matching path of length " + matchLen);
        }
    }
}

