/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package svgconverter;

/**
 *
 * @author Pap
 */
public class BezSegment {
    Double[]    p0 = new Double[2];
    Double[]    p1 = new Double[2];
    Double[]    p2 = new Double[2];
    Double[]    p3 = new Double[2];
    Double[]    v0 = new Double[2];
    Double[]    v1 = new Double[2];
    Double[]    v2 = new Double[2];
    Double[]    v3 = new Double[2];

    public BezSegment(double[] vals, double[] vvals) {
        p0[0] = vals[0];
        p0[1] = vals[1];
        p1[0] = vals[2];
        p1[1] = vals[3];
        p2[0] = vals[4];
        p2[1] = vals[5];
        p3[0] = vals[6];
        p3[1] = vals[7];

        v0[0] = vvals[0];
        v0[1] = vvals[1];
        v1[0] = vvals[2];
        v1[1] = vvals[3];
        v2[0] = vvals[4];
        v2[1] = vvals[5];
        v3[0] = vvals[6];
        v3[1] = vvals[7];
    }

    public boolean EqualsInverse(BezSegment other) {
//        double epsilon = 0.000000001;
        double epsilon = 0.0000000001;
        return (Math.abs(this.p0[0] - other.p3[0]) <= epsilon) &&
               (Math.abs(this.p0[1] - other.p3[1]) <= epsilon) &&
               (Math.abs(this.p1[0] - other.p2[0]) <= epsilon) &&
               (Math.abs(this.p1[1] - other.p2[1]) <= epsilon) &&
               (Math.abs(this.p2[0] - other.p1[0]) <= epsilon) &&
               (Math.abs(this.p2[1] - other.p1[1]) <= epsilon) &&
               (Math.abs(this.p3[0] - other.p0[0]) <= epsilon) &&
               (Math.abs(this.p3[1] - other.p0[1]) <= epsilon);
/*
        return (this.p0[0].doubleValue() == other.p3[0].doubleValue()) && (this.p0[1].doubleValue() == other.p3[1].doubleValue()) &&
               (this.p1[0].doubleValue() == other.p2[0].doubleValue()) && (this.p1[1].doubleValue() == other.p2[1].doubleValue()) &&
               (this.p2[0].doubleValue() == other.p1[0].doubleValue()) && (this.p2[1].doubleValue() == other.p1[1].doubleValue()) &&
               (this.p3[0].doubleValue() == other.p0[0].doubleValue()) && (this.p3[1].doubleValue() == other.p0[1].doubleValue());
 *
 */
    }
}
