package rns2tf3;

import java.util.Iterator;
import java.util.LinkedList;

/**
 *
 * @author pap
 */
public class Instrument {
    
    String m_name;
    int m_id;
    LinkedList<String> m_params;
    
    public Instrument(String name, LinkedList<String> params) {
        m_params = params;
        m_id = _idCounter++;
        m_name = name;
    }

    public String getXml() {
        String result = 
                "<instrument id=\"" + this.m_id + "\" name=\"" + this.m_name + "\">\n" +
                "<parameters>\n";
        Iterator<String> iter = this.m_params.iterator();
        int inst = 0;
        while(iter.hasNext()) {
            double val = Double.parseDouble(iter.next());
            String parName = instrumentParameters[inst];
            result +=
                    "<param value=\"" + val + "\" name=\"" + parName + "\"/>\n";
            inst++;
        }
        result +=
                "</parameters>\n" +
                "</instrument>\n";
        return result;
    }
    
    static int _idCounter = 0;

    // from tunefish3.hpp
    static String[] instrumentParameters = {
    "OscPoints",
    "OscP1Off",
    "OscP1Val",
    "OscP1Int",
    "OscP2Off",
    "OscP2Val",
    "OscP2Int",
    "OscP3Off",
    "OscP3Val",
    "OscP3Int",
    "OscP4Off",
    "OscP4Val",
    "OscP4Int",
    "OscFiInt",
    "OscVol",
    "OscFreq",
    "OscPan",
    "OscDetun",
    "OscPoly",
    "OscUnisn",
    "OscSpread",
    "OscSubOsc",
    "OscGlide",
    "OscDrive",
    "OscOctave",
    "OscOffset",
    "OscSlop",

    "AddVolume",
    "AddProfile",
    "AddOctave",
    "AddBandw",
    "AddDamp",
    "AddHarmncs",
    "AddScale",
    "AddDrive",

    "NoiseOn",
    "NoiseFreq",
    "NoiseBw",

    "FltLPOn",
    "FltLPCut",
    "FltLPRes",

    "FltHPOn",
    "FltHPCut",
    "FltHPRes",

    "FltBPOn",
    "FltBPCut",
    "FltBPQ",

    "FltNTOn",
    "FltNTCut",
    "FltNTQ",

    "Env1Att",
    "Env1Dec",
    "Env1Sus",
    "Env1Rel",
    "Env1Slp",

    "Env2Att",
    "Env2Dec",
    "Env2Sus",
    "Env2Rel",
    "Env2Slp",

    "Lfo1Rate",
    "Lfo1Dep",
    "Lfo1Shp",
    "Lfo1Sync",

    "Lfo2Rate",
    "Lfo2Dep",
    "Lfo2Shp",
    "Lfo2Sync",

    "Mm1Source",
    "Mm1Mod",
    "Mm1Target",
    "Mm2Source",
    "Mm2Mod",
    "Mm2Target",
    "Mm3Source",
    "Mm3Mod",
    "Mm3Target",
    "Mm4Source",
    "Mm4Mod",
    "Mm4Target",
    "Mm5Source",
    "Mm5Mod",
    "Mm5Target",
    "Mm6Source",
    "Mm6Mod",
    "Mm6Target",
    "Mm7Source",
    "Mm7Mod",
    "Mm7Target",
    "Mm8Source",
    "Mm8Mod",
    "Mm8Target",
    "Mm9Source",
    "Mm9Mod",
    "Mm9Target",
    "Mm10Sourc",
    "Mm10Mod",
    "Mm10Targe",

    "Effect1",
    "Effect2",
    "Effect3",
    "Effect4",
    "Effect5",
    "Effect6",
    "Effect7",
    "Effect8",
    "Effect9",
    "Effect10",

    "DistAmnt",

    "ChrsRate",
    "ChrsDep",

    "DelayL",
    "DelayR",
    "DelayDc",

    "RevRoom",
    "RevDamp",
    "RevWet",
    "RevWidth",

    "FlangLfo",
    "FlangFreq",
    "FlangAmp",
    "FlangWet",

    "GainAmount",

    "ChrsGain",

    "FrmtType",
    "FrmtWet",

    "EqLow",
    "EqMid",
    "EqHigh"
        
    };
    
}
