/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package rns2tf3;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

/**
 *
 * @author pap
 */
public class PatternTrack {
    int m_patternIndex;
    int m_trackNr;
    int m_numberOfLines;
    int m_numID;
    ArrayList<String> trackXmlFragments = new ArrayList<String>();
    
    PatternTrack(int patternIndex, int trackNr, int numberOfLines) {
        m_patternIndex = patternIndex;
        m_trackNr = trackNr;
        m_numberOfLines = numberOfLines;
        m_numID = m_trackIdCounter++;
    }

    void setNote(int trackNr, String line, String instrument, String noteVal) {
        while(this.trackXmlFragments.size() <= trackNr) {
            String fragment = "       <track>\n";
            this.trackXmlFragments.add(fragment);
        }
        String fragment = this.trackXmlFragments.get(trackNr);
        
        System.out.println("Pattern " + m_patternIndex + ":" + m_trackNr + " Line " + line + ": " + noteVal + " - " + instrument);
        int note = m_noteTranslator.get(noteVal);
        int inst = m_instTranslator.get(instrument);
        fragment += 
                "               <ne i=\"" + inst + "\" n=\"" + note + "\" r=\"" + line + "\" v=\"-1\" e=\"0\"/>\n";
        this.trackXmlFragments.set(trackNr, fragment);
    }

    boolean isIdentical(PatternTrack other) {
        if(this.trackXmlFragments.size() != other.trackXmlFragments.size())
            return false;
        for(int i = 0; i < this.trackXmlFragments.size(); i++) {
            if(!this.trackXmlFragments.get(i).equals(other.trackXmlFragments.get(i)))
                return false;
        }
        return true;
    }
    
    String getXml() {
        String Result = 
                "<pattern rowcount=\"" + m_numberOfLines + "\" patternid=\"" + m_numID + "\" trackcount=\"" + this.trackXmlFragments.size() + "\">\n" + 
                "   <tracks>\n";
        Iterator<String> iter = this.trackXmlFragments.iterator();
        while(iter.hasNext()) {
            String fragment = iter.next();
            Result += fragment;
            Result += "       </track>\n";
        }
        Result +=
                "   </tracks>\n" +
                "</pattern>";
        return Result;
    }
    
    static int m_trackIdCounter = 0;
    static HashMap<String, Integer> m_noteTranslator = new HashMap<String, Integer>();
    static HashMap<String, Integer> m_instTranslator = new HashMap<String, Integer>();
    static void init() {
        // build note translator
        m_noteTranslator.put("OFF", 0x80);
        for(int oct = 0; oct < 9; oct++) {
            int base = oct * 12 + 1;
            m_noteTranslator.put("C-" + oct, base + 0);
            m_noteTranslator.put("C#" + oct, base + 1);
            m_noteTranslator.put("D-" + oct, base + 2);
            m_noteTranslator.put("D#" + oct, base + 3);
            m_noteTranslator.put("E-" + oct, base + 4);
            m_noteTranslator.put("F-" + oct, base + 5);
            m_noteTranslator.put("F#" + oct, base + 6);
            m_noteTranslator.put("G-" + oct, base + 7);
            m_noteTranslator.put("G#" + oct, base + 8);
            m_noteTranslator.put("A-" + oct, base + 9);
            m_noteTranslator.put("A#" + oct, base + 10);
            m_noteTranslator.put("B-" + oct, base + 11);
        }
        
        m_instTranslator.put("..", -1);
        for(int i = 0; i < 10; i++) {
            int base = i * 16;
            for(int k = 0; k < 10; k++)
                m_instTranslator.put("" + i + "" + k, base + k);
            m_instTranslator.put("" + i + "A", base + 10);
            m_instTranslator.put("" + i + "B", base + 11);
            m_instTranslator.put("" + i + "C", base + 12);
            m_instTranslator.put("" + i + "D", base + 13);
            m_instTranslator.put("" + i + "E", base + 14);
            m_instTranslator.put("" + i + "F", base + 15);
        }
    }
}
