/*
 * Decompiled with CFR 0.152.
 */
package minishaderoptimizer;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.LinkedList;

public class MiniShaderOptimizer {
    static int accSize = 0;
    static int repSize = 0;
    static int static_globalsListStart;

    static String removeClosures(String s, char c0, char c1) {
        String newLine = "";
        int n = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == c0) {
                ++n;
                continue;
            }
            if (s.charAt(i) == c1) {
                --n;
                continue;
            }
            if (n != 0) continue;
            newLine = newLine + s.charAt(i);
        }
        return newLine;
    }

    public static String[] LineToTokens(String line) {
        line = line.replaceAll("\\\\ncbuffer", "\\\\nLINEBREAKcbuffer");
        line = line.replaceAll("\\\\nstruct", "\\\\nLINEBREAKstruct");
        String[] splitLineTokens = line.split("\\\\nLINEBREAK");
        for (int ll = 0; ll < splitLineTokens.length; ++ll) {
            line = splitLineTokens[ll];
            if (ll != 0) {
                line = "\"" + line;
            }
            if (ll != splitLineTokens.length - 1) {
                if (line.contains("#include")) {
                    line = line + "\\n";
                }
                line = line + "\"";
            }
            splitLineTokens[ll] = line;
        }
        return splitLineTokens;
    }

    public static void extractReplacement(String fileName, LinkedList<ReplacementRec> localList, String localChar, int localListOffset, LocalNameGen nameGen) {
        File file = new File(fileName);
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line = null;
            while ((line = reader.readLine()) != null) {
                String[] splitLineTokens = MiniShaderOptimizer.LineToTokens(line);
                for (int ll = 0; ll < splitLineTokens.length; ++ll) {
                    line = splitLineTokens[ll];
                    if (line.contains("#define")) continue;
                    try {
                        int r;
                        if ((line.matches(".*\"float[ 2-4] *[0-9a-zA-Z].*") || line.matches(".*\"bool[ 2-4] *[0-9a-zA-Z].*")) && line.endsWith(")\"")) {
                            String functionName = line.split("\"")[1].split(" ")[1].split("\\(")[0];
                            if (line.contains(functionName + "\\(")) continue;
                            if (nameGen != null) {
                                nameGen.GenName(functionName, localList);
                            } else {
                                ReplacementRec r2 = new ReplacementRec();
                                r2.name = functionName;
                                r2.replacement = localChar + (localList.size() + localListOffset);
                                localList.add(r2);
                            }
                        }
                        String[] replacer = new String[]{"RWTexture2D", "Texture2D", "cbuffer", "SamplerState", "SamplerComparisonState", "struct", "TextureCube"};
                        String lineSafe = line;
                        line = line.split("\"")[1];
                        String[] lines = line.split(";");
                        for (int l = 0; l < lines.length; ++l) {
                            line = lines[l];
                            for (r = 0; r < replacer.length; ++r) {
                                if (!line.contains(replacer[r])) continue;
                                System.out.println("TextLine: " + line);
                                String[] gparams = line.split(" ")[1].split(",");
                                for (int i = 0; i < gparams.length; ++i) {
                                    String name = gparams[i].split(":")[0];
                                    name = MiniShaderOptimizer.removeClosures(name, '[', ']');
                                    System.out.println("Replace \"" + replacer[r] + "\" : " + name);
                                    if (nameGen != null) {
                                        nameGen.GenName(name, localList);
                                        continue;
                                    }
                                    ReplacementRec rec = new ReplacementRec();
                                    rec.name = name;
                                    rec.replacement = localChar + (localList.size() + localListOffset);
                                    localList.add(rec);
                                }
                            }
                        }
                        line = lineSafe;
                        boolean contains = false;
                        for (r = 0; r < replacer.length; ++r) {
                            contains |= line.contains(replacer[r]);
                        }
                        if (contains) {
                            String[] cbuflines = line.split("\\{");
                            for (int l = 1; l < cbuflines.length; ++l) {
                                try {
                                    line = cbuflines[l];
                                    line = line.split("\\}")[0];
                                    String[] params = line.split(";");
                                    for (int i = 0; i < params.length; ++i) {
                                        String name = params[i].split(" ")[1].split(":")[0];
                                        if (nameGen != null) {
                                            nameGen.GenName(name, localList);
                                            continue;
                                        }
                                        ReplacementRec r3 = new ReplacementRec();
                                        r3.name = name;
                                        r3.replacement = localChar + (localList.size() + localListOffset);
                                        localList.add(r3);
                                    }
                                    continue;
                                }
                                catch (Exception eee) {
                                    // empty catch block
                                }
                            }
                        }
                        if (!(line = lineSafe).contains("static const")) continue;
                        String[] tmpToks = line.split(" ");
                        line = tmpToks[tmpToks.length - 1].split(";")[0];
                        line = MiniShaderOptimizer.removeClosures(line, '(', ')');
                        line = MiniShaderOptimizer.removeClosures(line, '{', '}');
                        String[] params = line.split(",");
                        for (int i = 0; i < params.length; ++i) {
                            String name = params[i].split("=")[0];
                            name = MiniShaderOptimizer.removeClosures(name, '[', ']');
                            if (nameGen != null) {
                                nameGen.GenName(name, localList);
                                continue;
                            }
                            ReplacementRec r4 = new ReplacementRec();
                            r4.name = name;
                            r4.replacement = localChar + (localList.size() + localListOffset);
                            localList.add(r4);
                        }
                        continue;
                    }
                    catch (Exception ee) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Extracted from " + fileName + ":");
        for (int i = 0; i < localList.size(); ++i) {
            System.out.println(" -> [" + localList.get((int)i).name + "]");
        }
    }

    public static void translateReplacement(String fileName, LinkedList<ReplacementRec> list, String outFileName, int pass) {
        File file = new File(fileName);
        File outFile = new File(outFileName);
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(outFile));
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line = null;
            while ((line = reader.readLine()) != null) {
                String[] splitLineTokens = MiniShaderOptimizer.LineToTokens(line);
                for (int ll = 0; ll < splitLineTokens.length; ++ll) {
                    line = splitLineTokens[ll];
                    if (outFileName.endsWith("globals.hpp") && line.contains("#define")) {
                        if (pass == 0) continue;
                        for (ReplacementRec r : list) {
                            if (!r.export) continue;
                            writer.write("\"#define " + r.replacement + " " + r.name + "\\n\"\n");
                        }
                        while (line.contains("#define")) {
                            line = reader.readLine();
                        }
                    }
                    if (line.contains("\"")) {
                        for (ReplacementRec r : list) {
                            try {
                                line = line.replaceAll("\\b" + r.name + "\\b", r.replacement);
                            }
                            catch (Exception ee) {}
                        }
                    }
                    writer.write(line + "\n");
                }
            }
            reader.close();
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        int i;
        String path;
        String pathInput = path = ".";
        File folder = new File(path);
        File[] listOfFiles = folder.listFiles();
        LinkedList<ReplacementRec> list = new LinkedList<ReplacementRec>();
        list.add(new ReplacementRec("packoffset", "H5", true));
        list.add(new ReplacementRec("GetDimensions", "H4", true));
        list.add(new ReplacementRec("SamplerState", "H3", true));
        list.add(new ReplacementRec("numthreads", "H2", true));
        list.add(new ReplacementRec("TextureCube", "H1", true));
        list.add(new ReplacementRec("SamplerComparisonState", "H0", true));
        list.add(new ReplacementRec("RWTexture2D", "h9", true));
        list.add(new ReplacementRec("Texture2D", "h8", true));
        list.add(new ReplacementRec("floor", "h7", true));
        list.add(new ReplacementRec("ShaderOutput", "h6", true));
        list.add(new ReplacementRec("ShaderInput", "h5", true));
        list.add(new ReplacementRec("main", "h4", true));
        list.add(new ReplacementRec("register", "h3", true));
        list.add(new ReplacementRec("smoothstep", "h2", true));
        list.add(new ReplacementRec("saturate", "h1", true));
        list.add(new ReplacementRec("normalize", "h0", true));
        list.add(new ReplacementRec("length", "g9", true));
        list.add(new ReplacementRec("const", "g8", true));
        list.add(new ReplacementRec("return", "g7", true));
        list.add(new ReplacementRec("float2x3", "F6", true));
        list.add(new ReplacementRec("float3x3", "F5", true));
        list.add(new ReplacementRec("float4x4", "F4", true));
        list.add(new ReplacementRec("float4", "F3", true));
        list.add(new ReplacementRec("float3", "F2", true));
        list.add(new ReplacementRec("float2", "F1", true));
        list.add(new ReplacementRec("float", "F0", true));
        list.add(new ReplacementRec("(3.14159265f)", "P1", true));
        list.add(new ReplacementRec("(2.f*3.14159265f)", "P2", true));
        list.add(new ReplacementRec("ePI", "P1", false));
        list.add(new ReplacementRec("eTWOPI", "P2", false));
        list.add(new ReplacementRec("eCBI_CAMERA", "b0", false));
        list.add(new ReplacementRec("eCBI_LIGHT", "b1", false));
        list.add(new ReplacementRec("eCBI_MATERIAL", "b2", false));
        list.add(new ReplacementRec("eCBI_FX_PARAMS", "b3", false));
        list.add(new ReplacementRec("eCBI_PASS_AMBIENT", "b4", false));
        list.add(new ReplacementRec("eCBI_PASS_SHADOW", "b5", false));
        static_globalsListStart = list.size();
        LinkedList<ReplacementRec> globalLocalList = new LinkedList<ReplacementRec>();
        MiniShaderOptimizer.extractReplacement(pathInput + "/globals.hpp", globalLocalList, "w", -globalLocalList.size(), null);
        for (i = 0; i < globalLocalList.size(); ++i) {
            System.out.println("Global Conv: " + globalLocalList.get((int)i).name + " -> " + globalLocalList.get((int)i).replacement);
        }
        MiniShaderOptimizer.translateReplacement(pathInput + "/globals.hpp", globalLocalList, path + "/globals.tst", 0);
        for (i = 0; i < listOfFiles.length; ++i) {
            if (!listOfFiles[i].isFile()) continue;
            LocalNameGen nameGen = new LocalNameGen();
            String fileName = pathInput + "/" + listOfFiles[i].getName();
            String fileNameTmp = path + "/" + listOfFiles[i].getName();
            String tempFileName = fileNameTmp.substring(0, fileNameTmp.length() - 4) + ".tmp";
            if (!fileName.endsWith(".hpp")) continue;
            LinkedList<ReplacementRec> localList = new LinkedList<ReplacementRec>();
            localList.addAll(list);
            localList.addAll(globalLocalList);
            MiniShaderOptimizer.extractReplacement(fileName, localList, "l", -localList.size(), nameGen);
            MiniShaderOptimizer.translateReplacement(fileName, localList, tempFileName, 0);
        }
        for (i = 0; i < listOfFiles.length; ++i) {
            if (!listOfFiles[i].isFile()) continue;
            String fileName = path + "/" + listOfFiles[i].getName();
            fileName = fileName.substring(0, fileName.length() - 4) + ".tmp";
            String outFileName = fileName.substring(0, fileName.length() - 4) + ".hpp";
            if (!listOfFiles[i].getName().endsWith(".hpp")) continue;
            MiniShaderOptimizer.translateReplacement(fileName, list, outFileName, 1);
        }
    }

    public static class LocalNameGen {
        static String[] usableVars = new String[0];
        int m_cnt = 0;

        public void GenName(String name, LinkedList<ReplacementRec> localList) {
            ReplacementRec r = new ReplacementRec();
            r.name = name;
            if (this.m_cnt < usableVars.length) {
                r.replacement = usableVars[this.m_cnt];
            } else {
                int cnt = this.m_cnt - usableVars.length;
                char c = 'l';
                c = (char)(c + cnt / 10);
                r.replacement = "" + c + cnt % 10;
            }
            localList.add(r);
            ++this.m_cnt;
        }
    }

    static class ReplacementRec {
        String name;
        String replacement;
        boolean export;

        public ReplacementRec() {
        }

        public ReplacementRec(String n, String r, boolean e) {
            this.export = e;
            this.name = n;
            this.replacement = r;
        }
    }
}

