/*
 * Decompiled with CFR 0.152.
 */
package kkrunchyanalyzer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import kkrunchyanalyzer.FunctionMapper;
import kkrunchyanalyzer.FunctionRecord;
import kkrunchyanalyzer.ObjectFile;
import kkrunchyanalyzer.PureRec;

public class Analyzer {
    FunctionMapper m_mapper = new FunctionMapper();
    LinkedList<FunctionRecord> m_pureRecs = new LinkedList();
    HashMap<String, PureRec> m_pureFunctions = new HashMap();
    FunctionMapper m_classMapper = new FunctionMapper();

    public void Parse(String fileName) {
        System.out.println("Analyzing KKrunchy logs ... ");
        boolean storeSize = true;
        File file = new File(fileName);
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line = null;
            while ((line = reader.readLine()) != null && !line.contains("Functions by object file and packed size")) {
                int endPos;
                if (!line.contains(".obj")) continue;
                String[] tokens = line.split(" ");
                String objFileName = tokens[tokens.length - 1];
                int maxPos = line.indexOf(objFileName);
                int pos = endPos = line.indexOf(":");
                while (line.charAt(pos) != ' ') {
                    --pos;
                }
                int startPos = pos + 1;
                int functionSize = Integer.parseInt(line.substring(startPos, endPos));
                if (functionSize == 0) continue;
                startPos = endPos + 1;
                while (line.charAt(startPos) == ' ') {
                    ++startPos;
                }
                endPos = maxPos;
                String functionName = line.substring(startPos, endPos);
                String funcString = functionName.replaceAll(" ", "").replaceAll("\t", "");
                String[] functionTokens = funcString.split("::");
                if (functionTokens.length == 2) {
                    String className = functionTokens[0];
                    String methodName = functionTokens[1];
                    this.m_classMapper.getObjectFile(className).AddFunction(methodName, functionSize);
                }
                this.m_mapper.getObjectFile(objFileName).AddFunction(functionName, functionSize);
                this.m_pureRecs.add(new FunctionRecord(functionName, objFileName, functionSize));
                if (!storeSize) continue;
                PureRec s = this.m_pureFunctions.get(functionName);
                if (s == null) {
                    s = new PureRec();
                    this.m_pureFunctions.put(functionName, s);
                }
                ++s.cnt;
                s.sizesum += functionSize;
            }
            System.out.println("Parsing complete");
            Collections.sort(this.m_pureRecs);
            String SEPARATOR = ";   ";
            for (int r = 0; r < 2; ++r) {
                String outFileName = r == 0 ? "KKLOG_by_ObjectFiles.csv" : "KKLOG_by_Classes.csv";
                FileWriter outFile = new FileWriter(outFileName);
                PrintWriter out = new PrintWriter(outFile);
                LinkedList<ObjectFile> fileList = r == 0 ? this.m_mapper.GetSorted() : this.m_classMapper.GetSorted();
                for (ObjectFile f : fileList) {
                    String outObjectFileName = f.m_name;
                    String outObjectFileSize = "" + f.m_size;
                    for (FunctionRecord rec : f.m_records) {
                        String outFunctionName = rec.m_name;
                        String outFunctionSize = "" + rec.m_size;
                        String st = outObjectFileSize + SEPARATOR + outObjectFileName + SEPARATOR + outFunctionSize + SEPARATOR + outFunctionName;
                        out.println(st);
                    }
                }
                out.close();
            }
            FileWriter outFile = new FileWriter("KKLOG_by_Functions.csv");
            PrintWriter out = new PrintWriter(outFile);
            for (FunctionRecord rec : this.m_pureRecs) {
                String st = rec.m_size + SEPARATOR + rec.m_name + SEPARATOR + this.m_mapper.getObjectFile((String)rec.m_objectFile).m_size + SEPARATOR + rec.m_objectFile;
                out.println(st);
            }
            out.close();
            LinkedList<FunctionRecord> m_singleRecs = new LinkedList<FunctionRecord>();
            for (Map.Entry<String, PureRec> e : this.m_pureFunctions.entrySet()) {
                m_singleRecs.add(new FunctionRecord(e.getKey(), e.getValue().cnt + " refs", e.getValue().sizesum));
            }
            Collections.sort(m_singleRecs);
            outFile = new FileWriter("KKLOG_by_Functions_global.csv");
            out = new PrintWriter(outFile);
            for (FunctionRecord rec : m_singleRecs) {
                String st = rec.m_size + SEPARATOR + rec.m_name + SEPARATOR + this.m_mapper.getObjectFile((String)rec.m_objectFile).m_size + SEPARATOR + rec.m_objectFile;
                out.println(st);
            }
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("KKrunchy log analyzation written !");
    }
}

