/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *   This file is part of
 *       ______        _                             __ __
 *      / ____/____   (_)____ _ ____ ___   ____ _   / // /
 *     / __/  / __ \ / // __ `// __ `__ \ / __ `/  / // /_
 *    / /___ / / / // // /_/ // / / / / // /_/ /  /__  __/
 *   /_____//_/ /_//_/ \__, //_/ /_/ /_/ \__,_/     /_/.   
 *                    /____/                              
 *
 *   Copyright  2003-2012 Brain Control, all rights reserved.
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "globals.hlsli"


Texture2D    g_tex: register(t0);
SamplerState g_ss:  register(s0);

struct ShaderInput
{
    float4 pos: SV_Position;
	float2 uv:  TEXCOORD0;
	float4 col: COLOR0;
};

float4 main(const ShaderInput input) : SV_Target0 
{
	return g_tex.Sample(g_ss, input.uv)*input.col;
}